/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConstProperties;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TopLevel;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.mozilla.javascript.debug.DebuggableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptableObject
implements Scriptable,
Serializable,
DebuggableObject,
ConstProperties {
    static final long serialVersionUID = 2829861078851942586L;
    public static final int EMPTY = 0;
    public static final int READONLY = 1;
    public static final int DONTENUM = 2;
    public static final int PERMANENT = 4;
    public static final int UNINITIALIZED_CONST = 8;
    public static final int CONST = 13;
    private Scriptable prototypeObject;
    private Scriptable parentScopeObject;
    private transient Slot[] slots;
    private int count;
    private transient Slot firstAdded;
    private transient Slot lastAdded;
    private volatile Map<Object, Object> associatedValues;
    private static final int SLOT_QUERY = 1;
    private static final int SLOT_MODIFY = 2;
    private static final int SLOT_MODIFY_CONST = 3;
    private static final int SLOT_MODIFY_GETTER_SETTER = 4;
    private static final int SLOT_CONVERT_ACCESSOR_TO_DATA = 5;
    private static final int INITIAL_SLOT_SIZE = 4;
    private boolean isExtensible = true;

    protected static ScriptableObject buildDataDescriptor(Scriptable scope, Object value2, int attributes2) {
        NativeObject desc = new NativeObject();
        ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
        desc.defineProperty("value", value2, 0);
        desc.defineProperty("writable", (attributes2 & 1) == 0, 0);
        desc.defineProperty("enumerable", (attributes2 & 2) == 0, 0);
        desc.defineProperty("configurable", (attributes2 & 4) == 0, 0);
        return desc;
    }

    static void checkValidAttributes(int attributes2) {
        int mask = 15;
        if ((attributes2 & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(String.valueOf(attributes2));
        }
    }

    public ScriptableObject() {
    }

    public ScriptableObject(Scriptable scope, Scriptable prototype) {
        if (scope == null) {
            throw new IllegalArgumentException();
        }
        this.parentScopeObject = scope;
        this.prototypeObject = prototype;
    }

    public String getTypeOf() {
        return this.avoidObjectDetection() ? "undefined" : "object";
    }

    @Override
    public abstract String getClassName();

    @Override
    public boolean has(String name, Scriptable start) {
        return null != this.getSlot(name, 0, 1);
    }

    @Override
    public boolean has(int index2, Scriptable start) {
        return null != this.getSlot((String)null, index2, 1);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Slot slot = this.getSlot(name, 0, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start);
    }

    @Override
    public Object get(int index2, Scriptable start) {
        Slot slot = this.getSlot((String)null, index2, 1);
        if (slot == null) {
            return Scriptable.NOT_FOUND;
        }
        return slot.getValue(start);
    }

    @Override
    public void put(String name, Scriptable start, Object value2) {
        if (this.putImpl(name, 0, start, value2)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(name, start, value2);
    }

    @Override
    public void put(int index2, Scriptable start, Object value2) {
        if (this.putImpl(null, index2, start, value2)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        start.put(index2, start, value2);
    }

    @Override
    public void delete(String name) {
        this.checkNotSealed(name, 0);
        this.removeSlot(name, 0);
    }

    @Override
    public void delete(int index2) {
        this.checkNotSealed(null, index2);
        this.removeSlot(null, index2);
    }

    @Override
    public void putConst(String name, Scriptable start, Object value2) {
        if (this.putConstImpl(name, 0, start, value2, 1)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).putConst(name, start, value2);
        } else {
            start.put(name, start, value2);
        }
    }

    @Override
    public void defineConst(String name, Scriptable start) {
        if (this.putConstImpl(name, 0, start, Undefined.instance, 8)) {
            return;
        }
        if (start == this) {
            throw Kit.codeBug();
        }
        if (start instanceof ConstProperties) {
            ((ConstProperties)((Object)start)).defineConst(name, start);
        }
    }

    @Override
    public boolean isConst(String name) {
        Slot slot = this.getSlot(name, 0, 1);
        if (slot == null) {
            return false;
        }
        return (slot.getAttributes() & 5) == 5;
    }

    public final int getAttributes(String name, Scriptable start) {
        return this.getAttributes(name);
    }

    public final int getAttributes(int index2, Scriptable start) {
        return this.getAttributes(index2);
    }

    public final void setAttributes(String name, Scriptable start, int attributes2) {
        this.setAttributes(name, attributes2);
    }

    public void setAttributes(int index2, Scriptable start, int attributes2) {
        this.setAttributes(index2, attributes2);
    }

    public int getAttributes(String name) {
        return this.findAttributeSlot(name, 0, 1).getAttributes();
    }

    public int getAttributes(int index2) {
        return this.findAttributeSlot(null, index2, 1).getAttributes();
    }

    public void setAttributes(String name, int attributes2) {
        this.checkNotSealed(name, 0);
        this.findAttributeSlot(name, 0, 2).setAttributes(attributes2);
    }

    public void setAttributes(int index2, int attributes2) {
        this.checkNotSealed(null, index2);
        this.findAttributeSlot(null, index2, 2).setAttributes(attributes2);
    }

    public void setGetterOrSetter(String name, int index2, Callable getterOrSetter, boolean isSetter) {
        this.setGetterOrSetter(name, index2, getterOrSetter, isSetter, false);
    }

    private void setGetterOrSetter(String name, int index2, Callable getterOrSetter, boolean isSetter, boolean force) {
        int attributes2;
        GetterSlot gslot;
        if (name != null && index2 != 0) {
            throw new IllegalArgumentException(name);
        }
        if (!force) {
            this.checkNotSealed(name, index2);
        }
        if (this.isExtensible()) {
            gslot = (GetterSlot)this.getSlot(name, index2, 4);
        } else {
            Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index2, 1));
            if (!(slot instanceof GetterSlot)) {
                return;
            }
            gslot = (GetterSlot)slot;
        }
        if (!force && ((attributes2 = gslot.getAttributes()) & 1) != 0) {
            throw Context.reportRuntimeError1("msg.modify.readonly", name);
        }
        if (isSetter) {
            gslot.setter = getterOrSetter;
        } else {
            gslot.getter = getterOrSetter;
        }
        gslot.value = Undefined.instance;
    }

    public Object getGetterOrSetter(String name, int index2, boolean isSetter) {
        if (name != null && index2 != 0) {
            throw new IllegalArgumentException(name);
        }
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index2, 1));
        if (slot == null) {
            return null;
        }
        if (slot instanceof GetterSlot) {
            GetterSlot gslot = (GetterSlot)slot;
            Object result2 = isSetter ? gslot.setter : gslot.getter;
            return result2 != null ? result2 : Undefined.instance;
        }
        return Undefined.instance;
    }

    protected boolean isGetterOrSetter(String name, int index2, boolean setter2) {
        Slot slot = ScriptableObject.unwrapSlot(this.getSlot(name, index2, 1));
        if (slot instanceof GetterSlot) {
            if (setter2 && ((GetterSlot)slot).setter != null) {
                return true;
            }
            if (!setter2 && ((GetterSlot)slot).getter != null) {
                return true;
            }
        }
        return false;
    }

    void addLazilyInitializedValue(String name, int index2, LazilyLoadedCtor init2, int attributes2) {
        if (name != null && index2 != 0) {
            throw new IllegalArgumentException(name);
        }
        this.checkNotSealed(name, index2);
        GetterSlot gslot = (GetterSlot)this.getSlot(name, index2, 4);
        gslot.setAttributes(attributes2);
        gslot.getter = null;
        gslot.setter = null;
        gslot.value = init2;
    }

    @Override
    public Scriptable getPrototype() {
        return this.prototypeObject;
    }

    @Override
    public void setPrototype(Scriptable m) {
        this.prototypeObject = m;
    }

    @Override
    public Scriptable getParentScope() {
        return this.parentScopeObject;
    }

    @Override
    public void setParentScope(Scriptable m) {
        this.parentScopeObject = m;
    }

    @Override
    public Object[] getIds() {
        return this.getIds(false);
    }

    @Override
    public Object[] getAllIds() {
        return this.getIds(true);
    }

    @Override
    public Object getDefaultValue(Class<?> typeHint) {
        return ScriptableObject.getDefaultValue(this, typeHint);
    }

    public static Object getDefaultValue(Scriptable object, Class<?> typeHint) {
        Context cx = null;
        for (int i = 0; i < 2; ++i) {
            Object u;
            Object[] args2;
            String methodName;
            boolean tryToString;
            if (typeHint == ScriptRuntime.StringClass) {
                tryToString = i == 0;
            } else {
                boolean bl = tryToString = i == 1;
            }
            if (tryToString) {
                methodName = "toString";
                args2 = ScriptRuntime.emptyArgs;
            } else {
                String hint;
                methodName = "valueOf";
                args2 = new Object[1];
                if (typeHint == null) {
                    hint = "undefined";
                } else if (typeHint == ScriptRuntime.StringClass) {
                    hint = "string";
                } else if (typeHint == ScriptRuntime.ScriptableClass) {
                    hint = "object";
                } else if (typeHint == ScriptRuntime.FunctionClass) {
                    hint = "function";
                } else if (typeHint == ScriptRuntime.BooleanClass || typeHint == Boolean.TYPE) {
                    hint = "boolean";
                } else if (typeHint == ScriptRuntime.NumberClass || typeHint == ScriptRuntime.ByteClass || typeHint == Byte.TYPE || typeHint == ScriptRuntime.ShortClass || typeHint == Short.TYPE || typeHint == ScriptRuntime.IntegerClass || typeHint == Integer.TYPE || typeHint == ScriptRuntime.FloatClass || typeHint == Float.TYPE || typeHint == ScriptRuntime.DoubleClass || typeHint == Double.TYPE) {
                    hint = "number";
                } else {
                    throw Context.reportRuntimeError1("msg.invalid.type", typeHint.toString());
                }
                args2[0] = hint;
            }
            Object v = ScriptableObject.getProperty(object, methodName);
            if (!(v instanceof Function)) continue;
            Function fun = (Function)v;
            if (cx == null) {
                cx = Context.getContext();
            }
            if ((v = fun.call(cx, fun.getParentScope(), object, args2)) == null) continue;
            if (!(v instanceof Scriptable)) {
                return v;
            }
            if (typeHint == ScriptRuntime.ScriptableClass || typeHint == ScriptRuntime.FunctionClass) {
                return v;
            }
            if (!tryToString || !(v instanceof Wrapper) || !((u = ((Wrapper)v).unwrap()) instanceof String)) continue;
            return u;
        }
        String arg = typeHint == null ? "undefined" : typeHint.getName();
        throw ScriptRuntime.typeError1("msg.default.value", arg);
    }

    @Override
    public boolean hasInstance(Scriptable instance) {
        return ScriptRuntime.jsDelegatesTo(instance, this);
    }

    public boolean avoidObjectDetection() {
        return false;
    }

    protected Object equivalentValues(Object value2) {
        return this == value2 ? Boolean.TRUE : Scriptable.NOT_FOUND;
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz2) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz2, false, false);
    }

    public static <T extends Scriptable> void defineClass(Scriptable scope, Class<T> clazz2, boolean sealed) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        ScriptableObject.defineClass(scope, clazz2, sealed, false);
    }

    public static <T extends Scriptable> String defineClass(Scriptable scope, Class<T> clazz2, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        BaseFunction ctor = ScriptableObject.buildClassCtor(scope, clazz2, sealed, mapInheritance);
        if (ctor == null) {
            return null;
        }
        String name = ctor.getClassPrototype().getClassName();
        ScriptableObject.defineProperty(scope, name, ctor, 2);
        return name;
    }

    static <T extends Scriptable> BaseFunction buildClassCtor(Scriptable scope, Class<T> clazz2, boolean sealed, boolean mapInheritance) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        FunctionObject ctor;
        Class<T> superScriptable;
        String name;
        Class<T> superClass;
        Object existingProto;
        AccessibleObject[] methods2 = FunctionObject.getMethodList(clazz2);
        for (int i = 0; i < methods2.length; ++i) {
            Method method2 = methods2[i];
            if (!method2.getName().equals("init")) continue;
            Class<?>[] parmTypes = method2.getParameterTypes();
            if (parmTypes.length == 3 && parmTypes[0] == ScriptRuntime.ContextClass && parmTypes[1] == ScriptRuntime.ScriptableClass && parmTypes[2] == Boolean.TYPE && Modifier.isStatic(method2.getModifiers())) {
                Object[] args2 = new Object[]{Context.getContext(), scope, sealed ? Boolean.TRUE : Boolean.FALSE};
                method2.invoke(null, args2);
                return null;
            }
            if (parmTypes.length != 1 || parmTypes[0] != ScriptRuntime.ScriptableClass || !Modifier.isStatic(method2.getModifiers())) continue;
            Object[] args3 = new Object[]{scope};
            method2.invoke(null, args3);
            return null;
        }
        AccessibleObject[] ctors = clazz2.getConstructors();
        Constructor<?> protoCtor = null;
        for (int i = 0; i < ctors.length; ++i) {
            if (ctors[i].getParameterTypes().length != 0) continue;
            protoCtor = ctors[i];
            break;
        }
        if (protoCtor == null) {
            throw Context.reportRuntimeError1("msg.zero.arg.ctor", clazz2.getName());
        }
        Scriptable proto = (Scriptable)protoCtor.newInstance(ScriptRuntime.emptyArgs);
        String className = proto.getClassName();
        Object existing = ScriptableObject.getProperty(ScriptableObject.getTopLevelScope(scope), className);
        if (existing instanceof BaseFunction && (existingProto = ((BaseFunction)existing).getPrototypeProperty()) != null && clazz2.equals(existingProto.getClass())) {
            return (BaseFunction)existing;
        }
        Scriptable superProto = null;
        if (mapInheritance && ScriptRuntime.ScriptableClass.isAssignableFrom(superClass = clazz2.getSuperclass()) && !Modifier.isAbstract(superClass.getModifiers()) && (name = ScriptableObject.defineClass(scope, superScriptable = ScriptableObject.extendsScriptable(superClass), sealed, mapInheritance)) != null) {
            superProto = ScriptableObject.getClassPrototype(scope, name);
        }
        if (superProto == null) {
            superProto = ScriptableObject.getObjectPrototype(scope);
        }
        proto.setPrototype(superProto);
        String functionPrefix = "jsFunction_";
        String staticFunctionPrefix = "jsStaticFunction_";
        String getterPrefix = "jsGet_";
        String setterPrefix = "jsSet_";
        String ctorName = "jsConstructor";
        Object ctorMember = ScriptableObject.findAnnotatedMember(methods2, JSConstructor.class);
        if (ctorMember == null) {
            ctorMember = ScriptableObject.findAnnotatedMember(ctors, JSConstructor.class);
        }
        if (ctorMember == null) {
            ctorMember = FunctionObject.findSingleMethod((Method[])methods2, "jsConstructor");
        }
        if (ctorMember == null) {
            if (ctors.length == 1) {
                ctorMember = ctors[0];
            } else if (ctors.length == 2) {
                if (((Constructor)ctors[0]).getParameterTypes().length == 0) {
                    ctorMember = ctors[1];
                } else if (((Constructor)ctors[1]).getParameterTypes().length == 0) {
                    ctorMember = ctors[0];
                }
            }
            if (ctorMember == null) {
                throw Context.reportRuntimeError1("msg.ctor.multiple.parms", clazz2.getName());
            }
        }
        if ((ctor = new FunctionObject(className, (Member)ctorMember, scope)).isVarArgsMethod()) {
            throw Context.reportRuntimeError1("msg.varargs.ctor", ctorMember.getName());
        }
        ctor.initAsConstructor(scope, proto);
        AccessibleObject finishInit = null;
        HashSet<String> staticNames = new HashSet<String>();
        HashSet instanceNames = new HashSet();
        for (AccessibleObject method3 : methods2) {
            String propName;
            boolean isStatic;
            HashSet<String> names;
            Class<?>[] parmTypes;
            if (method3 == ctorMember) continue;
            String name2 = ((Method)method3).getName();
            if (name2.equals("finishInit") && (parmTypes = ((Method)method3).getParameterTypes()).length == 3 && parmTypes[0] == ScriptRuntime.ScriptableClass && parmTypes[1] == FunctionObject.class && parmTypes[2] == ScriptRuntime.ScriptableClass && Modifier.isStatic(((Method)method3).getModifiers())) {
                finishInit = method3;
                continue;
            }
            if (name2.indexOf(36) != -1 || name2.equals("jsConstructor")) continue;
            Annotation annotation2 = null;
            String prefix = null;
            if (method3.isAnnotationPresent(JSFunction.class)) {
                annotation2 = ((Method)method3).getAnnotation(JSFunction.class);
            } else if (method3.isAnnotationPresent(JSStaticFunction.class)) {
                annotation2 = ((Method)method3).getAnnotation(JSStaticFunction.class);
            } else if (method3.isAnnotationPresent(JSGetter.class)) {
                annotation2 = ((Method)method3).getAnnotation(JSGetter.class);
            } else if (method3.isAnnotationPresent(JSSetter.class)) continue;
            if (annotation2 == null) {
                if (name2.startsWith("jsFunction_")) {
                    prefix = "jsFunction_";
                } else if (name2.startsWith("jsStaticFunction_")) {
                    prefix = "jsStaticFunction_";
                } else if (name2.startsWith("jsGet_")) {
                    prefix = "jsGet_";
                } else if (annotation2 == null) continue;
            }
            if ((names = (isStatic = annotation2 instanceof JSStaticFunction || prefix == "jsStaticFunction_") ? staticNames : instanceNames).contains(propName = ScriptableObject.getPropertyName(name2, prefix, annotation2))) {
                throw Context.reportRuntimeError2("duplicate.defineClass.name", name2, propName);
            }
            names.add(propName);
            name2 = propName;
            if (annotation2 instanceof JSGetter || prefix == "jsGet_") {
                if (!(proto instanceof ScriptableObject)) {
                    throw Context.reportRuntimeError2("msg.extend.scriptable", proto.getClass().toString(), name2);
                }
                Method setter2 = ScriptableObject.findSetterMethod((Method[])methods2, name2, "jsSet_");
                int attr = 6 | (setter2 != null ? 0 : 1);
                ((ScriptableObject)proto).defineProperty(name2, null, (Method)method3, setter2, attr);
                continue;
            }
            if (isStatic && !Modifier.isStatic(((Method)method3).getModifiers())) {
                throw Context.reportRuntimeError("jsStaticFunction must be used with static method.");
            }
            FunctionObject f2 = new FunctionObject(name2, (Member)((Object)method3), proto);
            if (f2.isVarArgsConstructor()) {
                throw Context.reportRuntimeError1("msg.varargs.fun", ctorMember.getName());
            }
            ScriptableObject.defineProperty(isStatic ? ctor : proto, name2, f2, 2);
            if (!sealed) continue;
            f2.sealObject();
        }
        if (finishInit != null) {
            Object[] finishArgs = new Object[]{scope, ctor, proto};
            finishInit.invoke(null, finishArgs);
        }
        if (sealed) {
            ctor.sealObject();
            if (proto instanceof ScriptableObject) {
                ((ScriptableObject)proto).sealObject();
            }
        }
        return ctor;
    }

    private static Member findAnnotatedMember(AccessibleObject[] members2, Class<? extends Annotation> annotation2) {
        for (AccessibleObject member : members2) {
            if (!member.isAnnotationPresent(annotation2)) continue;
            return (Member)((Object)member);
        }
        return null;
    }

    private static Method findSetterMethod(Method[] methods2, String name, String prefix) {
        String newStyleName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method2 : methods2) {
            JSSetter annotation2 = method2.getAnnotation(JSSetter.class);
            if (annotation2 == null || !name.equals(annotation2.value()) && (!"".equals(annotation2.value()) || !newStyleName.equals(method2.getName()))) continue;
            return method2;
        }
        String oldStyleName = prefix + name;
        for (Method method3 : methods2) {
            if (!oldStyleName.equals(method3.getName())) continue;
            return method3;
        }
        return null;
    }

    private static String getPropertyName(String methodName, String prefix, Annotation annotation2) {
        if (prefix != null) {
            return methodName.substring(prefix.length());
        }
        String propName = null;
        if (annotation2 instanceof JSGetter) {
            propName = ((JSGetter)annotation2).value();
            if ((propName == null || propName.length() == 0) && methodName.length() > 3 && methodName.startsWith("get") && Character.isUpperCase((propName = methodName.substring(3)).charAt(0))) {
                if (propName.length() == 1) {
                    propName = propName.toLowerCase();
                } else if (!Character.isUpperCase(propName.charAt(1))) {
                    propName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                }
            }
        } else if (annotation2 instanceof JSFunction) {
            propName = ((JSFunction)annotation2).value();
        } else if (annotation2 instanceof JSStaticFunction) {
            propName = ((JSStaticFunction)annotation2).value();
        }
        if (propName == null || propName.length() == 0) {
            propName = methodName;
        }
        return propName;
    }

    private static <T extends Scriptable> Class<T> extendsScriptable(Class<?> c) {
        if (ScriptRuntime.ScriptableClass.isAssignableFrom(c)) {
            return c;
        }
        return null;
    }

    public void defineProperty(String propertyName, Object value2, int attributes2) {
        this.checkNotSealed(propertyName, 0);
        this.put(propertyName, (Scriptable)this, value2);
        this.setAttributes(propertyName, attributes2);
    }

    public static void defineProperty(Scriptable destination, String propertyName, Object value2, int attributes2) {
        if (!(destination instanceof ScriptableObject)) {
            destination.put(propertyName, destination, value2);
            return;
        }
        ScriptableObject so = (ScriptableObject)destination;
        so.defineProperty(propertyName, value2, attributes2);
    }

    public static void defineConstProperty(Scriptable destination, String propertyName) {
        if (destination instanceof ConstProperties) {
            ConstProperties cp = (ConstProperties)((Object)destination);
            cp.defineConst(propertyName, destination);
        } else {
            ScriptableObject.defineProperty(destination, propertyName, Undefined.instance, 13);
        }
    }

    public void defineProperty(String propertyName, Class<?> clazz2, int attributes2) {
        int length = propertyName.length();
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        char[] buf = new char[3 + length];
        propertyName.getChars(0, length, buf, 3);
        buf[3] = Character.toUpperCase(buf[3]);
        buf[0] = 103;
        buf[1] = 101;
        buf[2] = 116;
        String getterName = new String(buf);
        buf[0] = 115;
        String setterName = new String(buf);
        Method[] methods2 = FunctionObject.getMethodList(clazz2);
        Method getter2 = FunctionObject.findSingleMethod(methods2, getterName);
        Method setter2 = FunctionObject.findSingleMethod(methods2, setterName);
        if (setter2 == null) {
            attributes2 |= 1;
        }
        this.defineProperty(propertyName, null, getter2, setter2 == null ? null : setter2, attributes2);
    }

    public void defineProperty(String propertyName, Object delegateTo, Method getter2, Method setter2, int attributes2) {
        MemberBox getterBox = null;
        if (getter2 != null) {
            boolean delegatedForm;
            getterBox = new MemberBox(getter2);
            if (!Modifier.isStatic(getter2.getModifiers())) {
                delegatedForm = delegateTo != null;
                getterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                getterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = getter2.getParameterTypes();
            if (parmTypes.length == 0) {
                if (delegatedForm) {
                    errorId = "msg.obj.getter.parms";
                }
            } else if (parmTypes.length == 1) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.bad.getter.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.bad.getter.parms";
                }
            } else {
                errorId = "msg.bad.getter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, getter2.toString());
            }
        }
        MemberBox setterBox = null;
        if (setter2 != null) {
            boolean delegatedForm;
            if (setter2.getReturnType() != Void.TYPE) {
                throw Context.reportRuntimeError1("msg.setter.return", setter2.toString());
            }
            setterBox = new MemberBox(setter2);
            if (!Modifier.isStatic(setter2.getModifiers())) {
                delegatedForm = delegateTo != null;
                setterBox.delegateTo = delegateTo;
            } else {
                delegatedForm = true;
                setterBox.delegateTo = Void.TYPE;
            }
            String errorId = null;
            Class<?>[] parmTypes = setter2.getParameterTypes();
            if (parmTypes.length == 1) {
                if (delegatedForm) {
                    errorId = "msg.setter2.expected";
                }
            } else if (parmTypes.length == 2) {
                Class<?> argType = parmTypes[0];
                if (argType != ScriptRuntime.ScriptableClass && argType != ScriptRuntime.ScriptableObjectClass) {
                    errorId = "msg.setter2.parms";
                } else if (!delegatedForm) {
                    errorId = "msg.setter1.parms";
                }
            } else {
                errorId = "msg.setter.parms";
            }
            if (errorId != null) {
                throw Context.reportRuntimeError1(errorId, setter2.toString());
            }
        }
        GetterSlot gslot = (GetterSlot)this.getSlot(propertyName, 0, 4);
        gslot.setAttributes(attributes2);
        gslot.getter = getterBox;
        gslot.setter = setterBox;
    }

    public void defineOwnProperties(Context cx, ScriptableObject props) {
        Object[] ids;
        for (Object id : ids = props.getIds()) {
            Object descObj = props.get(id);
            ScriptableObject desc = ScriptableObject.ensureScriptableObject(descObj);
            this.checkPropertyDefinition(desc);
        }
        for (Object id : ids) {
            ScriptableObject desc = (ScriptableObject)props.get(id);
            this.defineOwnProperty(cx, id, desc);
        }
    }

    public void defineOwnProperty(Context cx, Object id, ScriptableObject desc) {
        this.checkPropertyDefinition(desc);
        this.defineOwnProperty(cx, id, desc, true);
    }

    protected void defineOwnProperty(Context cx, Object id, ScriptableObject desc, boolean checkValid2) {
        int attributes2;
        boolean isNew;
        Slot slot = this.getSlot(cx, id, 1);
        boolean bl = isNew = slot == null;
        if (checkValid2) {
            ScriptableObject current = slot == null ? null : slot.getPropertyDescriptor(cx, this);
            String name = ScriptRuntime.toString(id);
            this.checkPropertyChange(name, current, desc);
        }
        boolean isAccessor = this.isAccessorDescriptor(desc);
        if (slot == null) {
            slot = this.getSlot(cx, id, isAccessor ? 4 : 2);
            attributes2 = this.applyDescriptorToAttributeBitset(7, desc);
        } else {
            attributes2 = this.applyDescriptorToAttributeBitset(slot.getAttributes(), desc);
        }
        slot = ScriptableObject.unwrapSlot(slot);
        if (isAccessor) {
            Object setter2;
            if (!(slot instanceof GetterSlot)) {
                slot = this.getSlot(cx, id, 4);
            }
            GetterSlot gslot = (GetterSlot)slot;
            Object getter2 = ScriptableObject.getProperty((Scriptable)desc, "get");
            if (getter2 != NOT_FOUND) {
                gslot.getter = getter2;
            }
            if ((setter2 = ScriptableObject.getProperty((Scriptable)desc, "set")) != NOT_FOUND) {
                gslot.setter = setter2;
            }
            gslot.value = Undefined.instance;
            gslot.setAttributes(attributes2);
        } else {
            Object value2;
            if (slot instanceof GetterSlot && this.isDataDescriptor(desc)) {
                slot = this.getSlot(cx, id, 5);
            }
            if ((value2 = ScriptableObject.getProperty((Scriptable)desc, "value")) != NOT_FOUND) {
                slot.value = value2;
            } else if (isNew) {
                slot.value = Undefined.instance;
            }
            slot.setAttributes(attributes2);
        }
    }

    protected void checkPropertyDefinition(ScriptableObject desc) {
        Object getter2 = ScriptableObject.getProperty((Scriptable)desc, "get");
        if (getter2 != NOT_FOUND && getter2 != Undefined.instance && !(getter2 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(getter2);
        }
        Object setter2 = ScriptableObject.getProperty((Scriptable)desc, "set");
        if (setter2 != NOT_FOUND && setter2 != Undefined.instance && !(setter2 instanceof Callable)) {
            throw ScriptRuntime.notFunctionError(setter2);
        }
        if (this.isDataDescriptor(desc) && this.isAccessorDescriptor(desc)) {
            throw ScriptRuntime.typeError0("msg.both.data.and.accessor.desc");
        }
    }

    protected void checkPropertyChange(String id, ScriptableObject current, ScriptableObject desc) {
        if (current == null) {
            if (!this.isExtensible()) {
                throw ScriptRuntime.typeError0("msg.not.extensible");
            }
        } else if (ScriptableObject.isFalse(current.get("configurable", (Scriptable)current))) {
            if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "configurable"))) {
                throw ScriptRuntime.typeError1("msg.change.configurable.false.to.true", id);
            }
            if (ScriptableObject.isTrue(current.get("enumerable", (Scriptable)current)) != ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "enumerable"))) {
                throw ScriptRuntime.typeError1("msg.change.enumerable.with.configurable.false", id);
            }
            boolean isData = this.isDataDescriptor(desc);
            boolean isAccessor = this.isAccessorDescriptor(desc);
            if (isData || isAccessor) {
                if (isData && this.isDataDescriptor(current)) {
                    if (ScriptableObject.isFalse(current.get("writable", (Scriptable)current))) {
                        if (ScriptableObject.isTrue(ScriptableObject.getProperty((Scriptable)desc, "writable"))) {
                            throw ScriptRuntime.typeError1("msg.change.writable.false.to.true.with.configurable.false", id);
                        }
                        if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "value"), current.get("value", (Scriptable)current))) {
                            throw ScriptRuntime.typeError1("msg.change.value.with.writable.false", id);
                        }
                    }
                } else if (isAccessor && this.isAccessorDescriptor(current)) {
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "set"), current.get("set", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1("msg.change.setter.with.configurable.false", id);
                    }
                    if (!this.sameValue(ScriptableObject.getProperty((Scriptable)desc, "get"), current.get("get", (Scriptable)current))) {
                        throw ScriptRuntime.typeError1("msg.change.getter.with.configurable.false", id);
                    }
                } else {
                    if (this.isDataDescriptor(current)) {
                        throw ScriptRuntime.typeError1("msg.change.property.data.to.accessor.with.configurable.false", id);
                    }
                    throw ScriptRuntime.typeError1("msg.change.property.accessor.to.data.with.configurable.false", id);
                }
            }
        }
    }

    protected static boolean isTrue(Object value2) {
        return value2 != NOT_FOUND && ScriptRuntime.toBoolean(value2);
    }

    protected static boolean isFalse(Object value2) {
        return !ScriptableObject.isTrue(value2);
    }

    protected boolean sameValue(Object newValue, Object currentValue) {
        if (newValue == NOT_FOUND) {
            return true;
        }
        if (currentValue == NOT_FOUND) {
            currentValue = Undefined.instance;
        }
        if (currentValue instanceof Number && newValue instanceof Number) {
            double d1 = ((Number)currentValue).doubleValue();
            double d2 = ((Number)newValue).doubleValue();
            if (Double.isNaN(d1) && Double.isNaN(d2)) {
                return true;
            }
            if (d1 == 0.0 && Double.doubleToLongBits(d1) != Double.doubleToLongBits(d2)) {
                return false;
            }
        }
        return ScriptRuntime.shallowEq(currentValue, newValue);
    }

    protected int applyDescriptorToAttributeBitset(int attributes2, ScriptableObject desc) {
        Object configurable;
        Object writable;
        Object enumerable = ScriptableObject.getProperty((Scriptable)desc, "enumerable");
        if (enumerable != NOT_FOUND) {
            int n = attributes2 = ScriptRuntime.toBoolean(enumerable) ? attributes2 & 0xFFFFFFFD : attributes2 | 2;
        }
        if ((writable = ScriptableObject.getProperty((Scriptable)desc, "writable")) != NOT_FOUND) {
            int n = attributes2 = ScriptRuntime.toBoolean(writable) ? attributes2 & 0xFFFFFFFE : attributes2 | 1;
        }
        if ((configurable = ScriptableObject.getProperty((Scriptable)desc, "configurable")) != NOT_FOUND) {
            attributes2 = ScriptRuntime.toBoolean(configurable) ? attributes2 & 0xFFFFFFFB : attributes2 | 4;
        }
        return attributes2;
    }

    protected boolean isDataDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "value") || ScriptableObject.hasProperty((Scriptable)desc, "writable");
    }

    protected boolean isAccessorDescriptor(ScriptableObject desc) {
        return ScriptableObject.hasProperty((Scriptable)desc, "get") || ScriptableObject.hasProperty((Scriptable)desc, "set");
    }

    protected boolean isGenericDescriptor(ScriptableObject desc) {
        return !this.isDataDescriptor(desc) && !this.isAccessorDescriptor(desc);
    }

    protected static Scriptable ensureScriptable(Object arg) {
        if (!(arg instanceof Scriptable)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return (Scriptable)arg;
    }

    protected static ScriptableObject ensureScriptableObject(Object arg) {
        if (!(arg instanceof ScriptableObject)) {
            throw ScriptRuntime.typeError1("msg.arg.not.object", ScriptRuntime.typeof(arg));
        }
        return (ScriptableObject)arg;
    }

    public void defineFunctionProperties(String[] names, Class<?> clazz2, int attributes2) {
        Method[] methods2 = FunctionObject.getMethodList(clazz2);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Method m = FunctionObject.findSingleMethod(methods2, name);
            if (m == null) {
                throw Context.reportRuntimeError2("msg.method.not.found", name, clazz2.getName());
            }
            FunctionObject f2 = new FunctionObject(name, m, this);
            this.defineProperty(name, f2, attributes2);
        }
    }

    public static Scriptable getObjectPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Object);
    }

    public static Scriptable getFunctionPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Function);
    }

    public static Scriptable getArrayPrototype(Scriptable scope) {
        return TopLevel.getBuiltinPrototype(ScriptableObject.getTopLevelScope(scope), TopLevel.Builtins.Array);
    }

    public static Scriptable getClassPrototype(Scriptable scope, String className) {
        Object proto;
        Object ctor = ScriptableObject.getProperty(scope = ScriptableObject.getTopLevelScope(scope), className);
        if (ctor instanceof BaseFunction) {
            proto = ((BaseFunction)ctor).getPrototypeProperty();
        } else if (ctor instanceof Scriptable) {
            Scriptable ctorObj = (Scriptable)ctor;
            proto = ctorObj.get("prototype", ctorObj);
        } else {
            return null;
        }
        if (proto instanceof Scriptable) {
            return (Scriptable)proto;
        }
        return null;
    }

    public static Scriptable getTopLevelScope(Scriptable obj) {
        Scriptable parent;
        while ((parent = obj.getParentScope()) != null) {
            obj = parent;
        }
        return obj;
    }

    public boolean isExtensible() {
        return this.isExtensible;
    }

    public void preventExtensions() {
        this.isExtensible = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sealObject() {
        if (this.count >= 0) {
            Slot slot = this.firstAdded;
            while (slot != null) {
                Object value2 = slot.value;
                if (value2 instanceof LazilyLoadedCtor) {
                    LazilyLoadedCtor initializer = (LazilyLoadedCtor)value2;
                    try {
                        initializer.init();
                    }
                    finally {
                        slot.value = initializer.getValue();
                    }
                }
                slot = slot.orderedNext;
            }
            this.count ^= 0xFFFFFFFF;
        }
    }

    public final boolean isSealed() {
        return this.count < 0;
    }

    private void checkNotSealed(String name, int index2) {
        if (!this.isSealed()) {
            return;
        }
        String str = name != null ? name : Integer.toString(index2);
        throw Context.reportRuntimeError1("msg.modify.sealed", str);
    }

    public static Object getProperty(Scriptable obj, String name) {
        Object result2;
        Scriptable start = obj;
        while ((result2 = obj.get(name, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result2;
    }

    public static <T> T getTypedProperty(Scriptable s2, int index2, Class<T> type) {
        Object val = ScriptableObject.getProperty(s2, index2);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type.cast(Context.jsToJava(val, type));
    }

    public static Object getProperty(Scriptable obj, int index2) {
        Object result2;
        Scriptable start = obj;
        while ((result2 = obj.get(index2, start)) == Scriptable.NOT_FOUND && (obj = obj.getPrototype()) != null) {
        }
        return result2;
    }

    public static <T> T getTypedProperty(Scriptable s2, String name, Class<T> type) {
        Object val = ScriptableObject.getProperty(s2, name);
        if (val == Scriptable.NOT_FOUND) {
            val = null;
        }
        return type.cast(Context.jsToJava(val, type));
    }

    public static boolean hasProperty(Scriptable obj, String name) {
        return null != ScriptableObject.getBase(obj, name);
    }

    public static void redefineProperty(Scriptable obj, String name, boolean isConst) {
        ConstProperties cp;
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return;
        }
        if (base instanceof ConstProperties && (cp = (ConstProperties)((Object)base)).isConst(name)) {
            throw Context.reportRuntimeError1("msg.const.redecl", name);
        }
        if (isConst) {
            throw Context.reportRuntimeError1("msg.var.redecl", name);
        }
    }

    public static boolean hasProperty(Scriptable obj, int index2) {
        return null != ScriptableObject.getBase(obj, index2);
    }

    public static void putProperty(Scriptable obj, String name, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        base.put(name, obj, value2);
    }

    public static void putConstProperty(Scriptable obj, String name, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            base = obj;
        }
        if (base instanceof ConstProperties) {
            ((ConstProperties)((Object)base)).putConst(name, obj, value2);
        }
    }

    public static void putProperty(Scriptable obj, int index2, Object value2) {
        Scriptable base = ScriptableObject.getBase(obj, index2);
        if (base == null) {
            base = obj;
        }
        base.put(index2, obj, value2);
    }

    public static boolean deleteProperty(Scriptable obj, String name) {
        Scriptable base = ScriptableObject.getBase(obj, name);
        if (base == null) {
            return true;
        }
        base.delete(name);
        return !base.has(name, obj);
    }

    public static boolean deleteProperty(Scriptable obj, int index2) {
        Scriptable base = ScriptableObject.getBase(obj, index2);
        if (base == null) {
            return true;
        }
        base.delete(index2);
        return !base.has(index2, obj);
    }

    public static Object[] getPropertyIds(Scriptable obj) {
        if (obj == null) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] result2 = obj.getIds();
        ObjToIntMap map2 = null;
        while ((obj = obj.getPrototype()) != null) {
            int i;
            Object[] ids = obj.getIds();
            if (ids.length == 0) continue;
            if (map2 == null) {
                if (result2.length == 0) {
                    result2 = ids;
                    continue;
                }
                map2 = new ObjToIntMap(result2.length + ids.length);
                for (i = 0; i != result2.length; ++i) {
                    map2.intern(result2[i]);
                }
                result2 = null;
            }
            for (i = 0; i != ids.length; ++i) {
                map2.intern(ids[i]);
            }
        }
        if (map2 != null) {
            result2 = map2.getKeys();
        }
        return result2;
    }

    public static Object callMethod(Scriptable obj, String methodName, Object[] args2) {
        return ScriptableObject.callMethod(null, obj, methodName, args2);
    }

    public static Object callMethod(Context cx, Scriptable obj, String methodName, Object[] args2) {
        Object funObj = ScriptableObject.getProperty(obj, methodName);
        if (!(funObj instanceof Function)) {
            throw ScriptRuntime.notFunctionError(obj, methodName);
        }
        Function fun = (Function)funObj;
        Scriptable scope = ScriptableObject.getTopLevelScope(obj);
        if (cx != null) {
            return fun.call(cx, scope, obj, args2);
        }
        return Context.call(null, fun, scope, obj, args2);
    }

    private static Scriptable getBase(Scriptable obj, String name) {
        while (!obj.has(name, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    private static Scriptable getBase(Scriptable obj, int index2) {
        while (!obj.has(index2, obj) && (obj = obj.getPrototype()) != null) {
        }
        return obj;
    }

    public final Object getAssociatedValue(Object key) {
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            return null;
        }
        return h.get(key);
    }

    public static Object getTopScopeValue(Scriptable scope, Object key) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            ScriptableObject so;
            Object value2;
            if (!(scope instanceof ScriptableObject) || (value2 = (so = (ScriptableObject)scope).getAssociatedValue(key)) == null) continue;
            return value2;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    public final synchronized Object associateValue(Object key, Object value2) {
        if (value2 == null) {
            throw new IllegalArgumentException();
        }
        Map<Object, Object> h = this.associatedValues;
        if (h == null) {
            this.associatedValues = h = new HashMap<Object, Object>();
        }
        return Kit.initHash(h, key, value2);
    }

    private boolean putImpl(String name, int index2, Scriptable start, Object value2) {
        Slot slot;
        if (this != start) {
            slot = this.getSlot(name, index2, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible) {
            slot = this.getSlot(name, index2, 1);
            if (slot == null) {
                return true;
            }
        } else {
            if (this.count < 0) {
                this.checkNotSealed(name, index2);
            }
            slot = this.getSlot(name, index2, 2);
        }
        return slot.setValue(value2, this, start);
    }

    private boolean putConstImpl(String name, int index2, Scriptable start, Object value2, int constFlag) {
        Slot slot;
        assert (constFlag != 0);
        if (this != start) {
            slot = this.getSlot(name, index2, 1);
            if (slot == null) {
                return false;
            }
        } else if (!this.isExtensible()) {
            slot = this.getSlot(name, index2, 1);
            if (slot == null) {
                return true;
            }
        } else {
            this.checkNotSealed(name, index2);
            Slot slot2 = ScriptableObject.unwrapSlot(this.getSlot(name, index2, 3));
            int attr = slot2.getAttributes();
            if ((attr & 1) == 0) {
                throw Context.reportRuntimeError1("msg.var.redecl", name);
            }
            if ((attr & 8) != 0) {
                slot2.value = value2;
                if (constFlag != 8) {
                    slot2.setAttributes(attr & 0xFFFFFFF7);
                }
            }
            return true;
        }
        return slot.setValue(value2, this, start);
    }

    private Slot findAttributeSlot(String name, int index2, int accessType) {
        Slot slot = this.getSlot(name, index2, accessType);
        if (slot == null) {
            String str = name != null ? name : Integer.toString(index2);
            throw Context.reportRuntimeError1("msg.prop.not.found", str);
        }
        return slot;
    }

    private static Slot unwrapSlot(Slot slot) {
        return slot instanceof RelinkedSlot ? ((RelinkedSlot)slot).slot : slot;
    }

    private Slot getSlot(String name, int index2, int accessType) {
        int indexOrHash;
        Slot[] slotsLocalRef = this.slots;
        if (slotsLocalRef == null && accessType == 1) {
            return null;
        }
        int n = indexOrHash = name != null ? name.hashCode() : index2;
        if (slotsLocalRef != null) {
            int slotIndex = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
            Slot slot = slotsLocalRef[slotIndex];
            while (slot != null) {
                String sname = slot.name;
                if (indexOrHash == slot.indexOrHash && (sname == name || name != null && name.equals(sname))) break;
                slot = slot.next;
            }
            switch (accessType) {
                case 1: {
                    return slot;
                }
                case 2: 
                case 3: {
                    if (slot == null) break;
                    return slot;
                }
                case 4: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (!(slot instanceof GetterSlot)) break;
                    return slot;
                }
                case 5: {
                    slot = ScriptableObject.unwrapSlot(slot);
                    if (slot instanceof GetterSlot) break;
                    return slot;
                }
            }
        }
        return this.createSlot(name, indexOrHash, accessType);
    }

    private synchronized Slot createSlot(String name, int indexOrHash, int accessType) {
        Slot newSlot;
        int insertPos;
        Slot[] slotsLocalRef = this.slots;
        if (this.count == 0) {
            slotsLocalRef = new Slot[4];
            this.slots = slotsLocalRef;
            insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
        } else {
            Slot prev;
            int tableSize = slotsLocalRef.length;
            insertPos = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
            Slot slot = prev = slotsLocalRef[insertPos];
            while (!(slot == null || slot.indexOrHash == indexOrHash && (slot.name == name || name != null && name.equals(slot.name)))) {
                prev = slot;
                slot = slot.next;
            }
            if (slot != null) {
                Slot newSlot2;
                Slot inner2 = ScriptableObject.unwrapSlot(slot);
                if (accessType == 4 && !(inner2 instanceof GetterSlot)) {
                    newSlot2 = new GetterSlot(name, indexOrHash, inner2.getAttributes());
                } else if (accessType == 5 && inner2 instanceof GetterSlot) {
                    newSlot2 = new Slot(name, indexOrHash, inner2.getAttributes());
                } else {
                    if (accessType == 3) {
                        return null;
                    }
                    return inner2;
                }
                newSlot2.value = inner2.value;
                newSlot2.next = slot.next;
                if (this.lastAdded != null) {
                    this.lastAdded.orderedNext = newSlot2;
                }
                if (this.firstAdded == null) {
                    this.firstAdded = newSlot2;
                }
                this.lastAdded = newSlot2;
                if (prev == slot) {
                    slotsLocalRef[insertPos] = newSlot2;
                } else {
                    prev.next = newSlot2;
                }
                slot.markDeleted();
                return newSlot2;
            }
            if (4 * (this.count + 1) > 3 * slotsLocalRef.length) {
                slotsLocalRef = new Slot[slotsLocalRef.length * 2];
                ScriptableObject.copyTable(this.slots, slotsLocalRef, this.count);
                this.slots = slotsLocalRef;
                insertPos = ScriptableObject.getSlotIndex(slotsLocalRef.length, indexOrHash);
            }
        }
        Slot slot = newSlot = accessType == 4 ? new GetterSlot(name, indexOrHash, 0) : new Slot(name, indexOrHash, 0);
        if (accessType == 3) {
            newSlot.setAttributes(13);
        }
        ++this.count;
        if (this.lastAdded != null) {
            this.lastAdded.orderedNext = newSlot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = newSlot;
        }
        this.lastAdded = newSlot;
        ScriptableObject.addKnownAbsentSlot(slotsLocalRef, newSlot, insertPos);
        return newSlot;
    }

    private synchronized void removeSlot(String name, int index2) {
        int indexOrHash = name != null ? name.hashCode() : index2;
        Slot[] slotsLocalRef = this.slots;
        if (this.count != 0) {
            Slot prev;
            int tableSize = slotsLocalRef.length;
            int slotIndex = ScriptableObject.getSlotIndex(tableSize, indexOrHash);
            Slot slot = prev = slotsLocalRef[slotIndex];
            while (!(slot == null || slot.indexOrHash == indexOrHash && (slot.name == name || name != null && name.equals(slot.name)))) {
                prev = slot;
                slot = slot.next;
            }
            if (slot != null && (slot.getAttributes() & 4) == 0) {
                --this.count;
                if (prev == slot) {
                    slotsLocalRef[slotIndex] = slot.next;
                } else {
                    prev.next = slot.next;
                }
                Slot deleted = ScriptableObject.unwrapSlot(slot);
                if (deleted == this.firstAdded) {
                    prev = null;
                    this.firstAdded = deleted.orderedNext;
                } else {
                    prev = this.firstAdded;
                    while (prev.orderedNext != deleted) {
                        prev = prev.orderedNext;
                    }
                    prev.orderedNext = deleted.orderedNext;
                }
                if (deleted == this.lastAdded) {
                    this.lastAdded = prev;
                }
                slot.markDeleted();
            }
        }
    }

    private static int getSlotIndex(int tableSize, int indexOrHash) {
        return indexOrHash & tableSize - 1;
    }

    private static void copyTable(Slot[] oldSlots, Slot[] newSlots, int count2) {
        if (count2 == 0) {
            throw Kit.codeBug();
        }
        int tableSize = newSlots.length;
        int i = oldSlots.length;
        block0: while (true) {
            Slot slot = oldSlots[--i];
            do {
                if (slot == null) continue block0;
                int insertPos = ScriptableObject.getSlotIndex(tableSize, slot.indexOrHash);
                Slot insSlot = slot.next == null ? slot : new RelinkedSlot(slot);
                ScriptableObject.addKnownAbsentSlot(newSlots, insSlot, insertPos);
                slot = slot.next;
            } while (--count2 != 0);
            break;
        }
    }

    private static void addKnownAbsentSlot(Slot[] slots, Slot slot, int insertPos) {
        if (slots[insertPos] == null) {
            slots[insertPos] = slot;
        } else {
            Slot prev = slots[insertPos];
            Slot next2 = prev.next;
            while (next2 != null) {
                prev = next2;
                next2 = prev.next;
            }
            prev.next = slot;
        }
    }

    Object[] getIds(boolean getAll) {
        Slot[] s2 = this.slots;
        Object[] a = ScriptRuntime.emptyArgs;
        if (s2 == null) {
            return a;
        }
        int c = 0;
        Slot slot = this.firstAdded;
        while (slot != null && slot.wasDeleted) {
            slot = slot.orderedNext;
        }
        while (slot != null) {
            if (getAll || (slot.getAttributes() & 2) == 0) {
                if (c == 0) {
                    a = new Object[s2.length];
                }
                a[c++] = slot.name != null ? slot.name : Integer.valueOf(slot.indexOrHash);
            }
            slot = slot.orderedNext;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
        }
        if (c == a.length) {
            return a;
        }
        Object[] result2 = new Object[c];
        System.arraycopy(a, 0, result2, 0, c);
        return result2;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        int objectsCount = this.count;
        if (objectsCount < 0) {
            objectsCount ^= 0xFFFFFFFF;
        }
        if (objectsCount == 0) {
            out.writeInt(0);
        } else {
            out.writeInt(this.slots.length);
            Slot slot = this.firstAdded;
            while (slot != null && slot.wasDeleted) {
                slot = slot.orderedNext;
            }
            this.firstAdded = slot;
            while (slot != null) {
                out.writeObject(slot);
                Slot next2 = slot.orderedNext;
                while (next2 != null && next2.wasDeleted) {
                    next2 = next2.orderedNext;
                }
                slot.orderedNext = next2;
                slot = next2;
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int tableSize = in.readInt();
        if (tableSize != 0) {
            if ((tableSize & tableSize - 1) != 0) {
                int newSize;
                if (tableSize > 0x40000000) {
                    throw new RuntimeException("Property table overflow");
                }
                for (newSize = 4; newSize < tableSize; newSize <<= 1) {
                }
                tableSize = newSize;
            }
            this.slots = new Slot[tableSize];
            int objectsCount = this.count;
            if (objectsCount < 0) {
                objectsCount ^= 0xFFFFFFFF;
            }
            Slot prev = null;
            for (int i = 0; i != objectsCount; ++i) {
                this.lastAdded = (Slot)in.readObject();
                if (i == 0) {
                    this.firstAdded = this.lastAdded;
                } else {
                    prev.orderedNext = this.lastAdded;
                }
                int slotIndex = ScriptableObject.getSlotIndex(tableSize, this.lastAdded.indexOrHash);
                ScriptableObject.addKnownAbsentSlot(this.slots, this.lastAdded, slotIndex);
                prev = this.lastAdded;
            }
        }
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        Slot slot = this.getSlot(cx, id, 1);
        if (slot == null) {
            return null;
        }
        Scriptable scope = this.getParentScope();
        return slot.getPropertyDescriptor(cx, scope == null ? this : scope);
    }

    protected Slot getSlot(Context cx, Object id, int accessType) {
        String name = ScriptRuntime.toStringIdOrIndex(cx, id);
        if (name == null) {
            return this.getSlot((String)null, ScriptRuntime.lastIndexResult(cx), accessType);
        }
        return this.getSlot(name, 0, accessType);
    }

    public int size() {
        return this.count < 0 ? ~this.count : this.count;
    }

    public boolean isEmpty() {
        return this.count == 0 || this.count == -1;
    }

    public Object get(Object key) {
        Object value2 = null;
        if (key instanceof String) {
            value2 = this.get((String)key, (Scriptable)this);
        } else if (key instanceof Number) {
            value2 = this.get(((Number)key).intValue(), (Scriptable)this);
        }
        if (value2 == Scriptable.NOT_FOUND || value2 == Undefined.instance) {
            return null;
        }
        if (value2 instanceof Wrapper) {
            return ((Wrapper)value2).unwrap();
        }
        return value2;
    }

    private static class RelinkedSlot
    extends Slot {
        final Slot slot;

        RelinkedSlot(Slot slot) {
            super(slot.name, slot.indexOrHash, slot.attributes);
            this.slot = ScriptableObject.unwrapSlot(slot);
        }

        boolean setValue(Object value2, Scriptable owner2, Scriptable start) {
            return this.slot.setValue(value2, owner2, start);
        }

        Object getValue(Scriptable start) {
            return this.slot.getValue(start);
        }

        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            return this.slot.getPropertyDescriptor(cx, scope);
        }

        int getAttributes() {
            return this.slot.getAttributes();
        }

        void setAttributes(int value2) {
            this.slot.setAttributes(value2);
        }

        void markDeleted() {
            super.markDeleted();
            this.slot.markDeleted();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.slot);
        }
    }

    private static final class GetterSlot
    extends Slot {
        static final long serialVersionUID = -4900574849788797588L;
        Object getter;
        Object setter;

        GetterSlot(String name, int indexOrHash, int attributes2) {
            super(name, indexOrHash, attributes2);
        }

        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            int attr = this.getAttributes();
            NativeObject desc = new NativeObject();
            ScriptRuntime.setBuiltinProtoAndParent(desc, scope, TopLevel.Builtins.Object);
            desc.defineProperty("enumerable", (attr & 2) == 0, 0);
            desc.defineProperty("configurable", (attr & 4) == 0, 0);
            if (this.getter != null) {
                desc.defineProperty("get", this.getter, 0);
            }
            if (this.setter != null) {
                desc.defineProperty("set", this.setter, 0);
            }
            return desc;
        }

        boolean setValue(Object value2, Scriptable owner2, Scriptable start) {
            if (this.setter == null) {
                if (this.getter != null) {
                    if (Context.getContext().hasFeature(11)) {
                        throw ScriptRuntime.typeError1("msg.set.prop.no.setter", this.name);
                    }
                    return true;
                }
            } else {
                Context cx = Context.getContext();
                if (this.setter instanceof MemberBox) {
                    Object[] args2;
                    Object setterThis;
                    MemberBox nativeSetter = (MemberBox)this.setter;
                    Class<?>[] pTypes = nativeSetter.argTypes;
                    Class<?> valueType = pTypes[pTypes.length - 1];
                    int tag = FunctionObject.getTypeTag(valueType);
                    Object actualArg = FunctionObject.convertArg(cx, start, value2, tag);
                    if (nativeSetter.delegateTo == null) {
                        setterThis = start;
                        args2 = new Object[]{actualArg};
                    } else {
                        setterThis = nativeSetter.delegateTo;
                        args2 = new Object[]{start, actualArg};
                    }
                    nativeSetter.invoke(setterThis, args2);
                } else if (this.setter instanceof Function) {
                    Function f2 = (Function)this.setter;
                    f2.call(cx, f2.getParentScope(), start, new Object[]{value2});
                }
                return true;
            }
            return super.setValue(value2, owner2, start);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getValue(Scriptable start) {
            Object val;
            if (this.getter != null) {
                if (this.getter instanceof MemberBox) {
                    Object[] args2;
                    Object getterThis;
                    MemberBox nativeGetter = (MemberBox)this.getter;
                    if (nativeGetter.delegateTo == null) {
                        getterThis = start;
                        args2 = ScriptRuntime.emptyArgs;
                    } else {
                        getterThis = nativeGetter.delegateTo;
                        args2 = new Object[]{start};
                    }
                    return nativeGetter.invoke(getterThis, args2);
                }
                if (this.getter instanceof Function) {
                    Function f2 = (Function)this.getter;
                    Context cx = Context.getContext();
                    return f2.call(cx, f2.getParentScope(), start, ScriptRuntime.emptyArgs);
                }
            }
            if ((val = this.value) instanceof LazilyLoadedCtor) {
                LazilyLoadedCtor initializer = (LazilyLoadedCtor)val;
                try {
                    initializer.init();
                }
                finally {
                    this.value = val = initializer.getValue();
                }
            }
            return val;
        }

        void markDeleted() {
            super.markDeleted();
            this.getter = null;
            this.setter = null;
        }
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = -6090581677123995491L;
        String name;
        int indexOrHash;
        private volatile short attributes;
        volatile transient boolean wasDeleted;
        volatile Object value;
        transient Slot next;
        volatile transient Slot orderedNext;

        Slot(String name, int indexOrHash, int attributes2) {
            this.name = name;
            this.indexOrHash = indexOrHash;
            this.attributes = (short)attributes2;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.name != null) {
                this.indexOrHash = this.name.hashCode();
            }
        }

        boolean setValue(Object value2, Scriptable owner2, Scriptable start) {
            if ((this.attributes & 1) != 0) {
                return true;
            }
            if (owner2 == start) {
                this.value = value2;
                return true;
            }
            return false;
        }

        Object getValue(Scriptable start) {
            return this.value;
        }

        int getAttributes() {
            return this.attributes;
        }

        synchronized void setAttributes(int value2) {
            ScriptableObject.checkValidAttributes(value2);
            this.attributes = (short)value2;
        }

        void markDeleted() {
            this.wasDeleted = true;
            this.value = null;
            this.name = null;
        }

        ScriptableObject getPropertyDescriptor(Context cx, Scriptable scope) {
            return ScriptableObject.buildDataDescriptor(scope, this.value, this.attributes);
        }
    }
}

